<?php
function mm_get_prompt_limit($user_id, $prompt_type) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'model_manager_prompt_limits';
    $limit = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE user_id = %d AND prompt_type = %s", $user_id, $prompt_type), ARRAY_A);
    $global_price = get_option("mm_{$prompt_type}_prompt_price", 0.05); // Default to 0.05
    $global_limit = get_option("mm_{$prompt_type}_prompt_free_limit", 0); // Default to 0
    return [
        'price' => $limit['price_override'] ?? $global_price,
        'free_limit' => $limit['free_limit'] ?? $global_limit,
        'used_prompts' => $limit['used_prompts'] ?? 0
    ];
}

function mm_update_used_prompts($user_id, $prompt_type) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'model_manager_prompt_limits';
    $limit = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE user_id = %d AND prompt_type = %s", $user_id, $prompt_type), ARRAY_A);
    if ($limit) {
        $wpdb->update($table_name, ['used_prompts' => $limit['used_prompts'] + 1], ['id' => $limit['id']]);
    } else {
        $wpdb->insert($table_name, [
            'user_id' => $user_id,
            'prompt_type' => $prompt_type,
            'free_limit' => get_option("mm_{$prompt_type}_prompt_free_limit", 0),
            'used_prompts' => 1,
            'price_override' => null
        ]);
    }
}

function mm_prompt_settings_page() {
    if (!current_user_can('manage_options')) {
        wp_die('Unauthorized');
    }

    // Handle prompt settings submission
    if (isset($_POST['mm_submit_prompt_settings']) && check_admin_referer('mm_save_prompt_settings')) {
        update_option('mm_spicy_prompt_price', floatval($_POST['spicy_price']));
        update_option('mm_spicy_prompt_free_limit', intval($_POST['spicy_free_limit']));
        echo '<div class="notice notice-success"><p>Prompt settings saved!</p></div>';
    }
    ?>
    <div class="wrap">
        <h1>Prompt Settings</h1>
        <form method="post" action="">
            <?php wp_nonce_field('mm_save_prompt_settings'); ?>
            <table class="form-table">
                <tr>
                    <th><label for="spicy_price">Spicy Prompt Price (Credits)</label></th>
                    <td><input type="number" step="0.01" name="spicy_price" id="spicy_price" value="<?php echo esc_attr(get_option('mm_spicy_prompt_price', 0.00)); ?>" min="0"></td>
                </tr>
                <tr>
                    <th><label for="spicy_free_limit">Spicy Free Prompt Limit</label></th>
                    <td><input type="number" name="spicy_free_limit" id="spicy_free_limit" value="<?php echo esc_attr(get_option('mm_spicy_prompt_free_limit', 0)); ?>" min="0"></td>
                </tr>
            </table>
            <p class="submit"><input type="submit" name="mm_submit_prompt_settings" class="button-primary" value="Save Prompt Settings"></p>
        </form>
    </div>
    <?php
}