<?php
function mm_add_edit_model_page() {
    if (!current_user_can('manage_options')) {
        wp_die('Unauthorized');
    }

    global $wpdb;
    $models_table = $wpdb->prefix . 'model_manager_models';
    $user_models_table = $wpdb->prefix . 'model_manager_user_models';

    $action = isset($_GET['action']) ? $_GET['action'] : '';
    $model_type = isset($_GET['model_type']) ? $_GET['model_type'] : '';
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;

    $is_edit = ($action === 'edit' && $id > 0);

    if (!$is_edit) {
        wp_die('This page is only for editing existing models. Go to Model Manager and click on Edit under Actions');
    }
    if (isset($_POST['mm_submit_model']) && check_admin_referer('mm_save_model')) {
        $type = $_POST['type'] === 'custom' ? $_POST['custom_type'] : $_POST['type'];
        $data = [
            'name' => $_POST['name'],
            'tune_id' => $_POST['tune_id'],
            'type' => $type,
            'spicy_credit_cost' => $_POST['spicy_credit_cost'],
        ];
        if ($type !== 'user_container') {
            $data['trigger_name'] = sanitize_text_field($_POST['trigger_name']);
        }
        if ($type === 'user_container') {
            $data['user_id'] = $_POST['user_model_user_id'];
            $data['class_name'] = $_POST['user_model_class_name'];
            if (isset($_POST['model_id']) && !empty($_POST['model_id'])) {
                if ($model_type === 'user') {
                    mm_update_user_model(intval($_POST['model_id']), $data);
                } else {
                    mm_update_model(intval($_POST['model_id']), $data);
                }
                echo '<div class="notice notice-success"><p>Model updated!</p></div>';
            } else {
                echo '<div class="notice notice-error"><p>Cannot add new models.</p></div>';
            }
        } else {
            if (isset($_POST['model_id']) && !empty($_POST['model_id'])) {
                mm_update_model(intval($_POST['model_id']), $data);
                echo '<div class="notice notice-success"><p>Model updated!</p></div>';
            } else {
                mm_add_model($data);
                echo '<div class="notice notice-success"><p>Model added!</p></div>';
            }
        }
    }
    
    $model = null;
    $model_type_val = '';
    $custom_type_val = '';
    $user_id_val = '';
    $class_name_val = '';

    if ($model_type === 'default') {
        $model = $wpdb->get_row($wpdb->prepare("SELECT * FROM $models_table WHERE id = %d", $id), ARRAY_A);
        if ($model) {
            $standard_types = ['default', 'alternative', 'premium1', 'user_container'];
            $model_type_val = in_array($model['type'], $standard_types) ? $model['type'] : 'custom';
            $custom_type_val = in_array($model['type'], $standard_types) ? '' : $model['type'];
        }
    } elseif ($model_type === 'user') {
        $model = $wpdb->get_row($wpdb->prepare("SELECT * FROM $user_models_table WHERE id = %d", $id), ARRAY_A);
        if ($model) {
            $model_type_val = 'user_container';
            $user_id_val = $model['user_id'];
            $class_name_val = $model['class_name'];
        }
    }

    if ($model === null) {
        wp_die('Model not found');
    }

    ?>
    <div class="wrap">
        <h1>Edit Model</h1>

        <!-- Model Form (shared for regular and user models) -->
        <form method="post" action="">
            <?php wp_nonce_field('mm_save_model'); ?>
            <table class="form-table">
                <tr>
                    <th><label for="name">Model Name</label></th>
                    <td><input type="text" name="name" id="name" value="<?php echo isset($model['name']) ? esc_attr($model['name']) : ''; ?>" required <?php if ($is_edit) echo 'readonly="readonly"'; ?>></td>
                </tr>
                <tr>
                    <th><label for="tune_id">Tune ID</label></th>
                    <td><input type="text" name="tune_id" id="tune_id" value="<?php echo isset($model['tune_id']) ? esc_attr($model['tune_id']) : ''; ?>" <?php if ($is_edit) echo 'readonly="readonly"'; ?>></td>
                </tr>
                <tr>
                    <th><label for="type">Type</label></th>
                    <td>
                        <select name="type" id="type" onchange="toggleCustomType()" <?php if ($is_edit) echo 'disabled="disabled"'; ?>>
                            <option value="default" <?php echo $model_type_val === 'default' ? 'selected' : ''; ?>>Default</option>
                            <option value="alternative" <?php echo $model_type_val === 'alternative' ? 'selected' : ''; ?>>Alternative</option>
                            <option value="premium1" <?php echo $model_type_val === 'premium1' ? 'selected' : ''; ?>>Premium1</option>
                            <option value="user_container" <?php echo $model_type_val === 'user_container' ? 'selected' : ''; ?>>User Models (My Models)</option>
                            <option value="custom" <?php echo $model_type_val === 'custom' ? 'selected' : ''; ?>>Custom</option>
                        </select>
                        <?php if ($is_edit) { ?>
                            <input type="hidden" name="type" value="<?php echo esc_attr($model_type_val); ?>">
                        <?php } ?>
                        <input type="text" name="custom_type" id="custom_type" style="display:none;" placeholder="Enter custom type" value="<?php echo esc_attr($custom_type_val); ?>" <?php if ($is_edit) echo 'readonly="readonly"'; ?>>
                    </td>
                </tr>
                <tr id="user_model_user_id_row" style="display:none;">
                    <th><label for="user_model_user_id">User ID</label></th>
                    <td><input type="number" name="user_model_user_id" id="user_model_user_id" value="<?php echo esc_attr($user_id_val); ?>" required <?php if ($is_edit) echo 'readonly="readonly"'; ?>></td>
                </tr>
                <tr id="user_model_class_name_row" style="display:none;">
                    <th><label for="user_model_class_name">Trigger Name</label></th>
                    <td><input type="text" name="user_model_class_name" id="user_model_class_name" value="<?php echo esc_attr($class_name_val); ?>" required <?php if ($is_edit) echo 'readonly="readonly"'; ?>></td>
                </tr>
                <tr>
                    <th><label for="spicy_credit_cost">Spicy Image Cost</label></th>
                    <td><input type="number" step="0.01" name="spicy_credit_cost" id="spicy_credit_cost" value="<?php echo isset($model['spicy_credit_cost']) ? esc_attr($model['spicy_credit_cost']) : '0.50'; ?>" required></td>
                </tr>
                <tr id="trigger_name_row">
                    <th><label for="trigger_name">Trigger Name</label></th>
                    <td><input type="text" name="trigger_name" id="trigger_name" placeholder="e.g., blonde woman" value="<?php echo isset($model['trigger_name']) ? esc_attr($model['trigger_name']) : ''; ?>" <?php if ($is_edit) echo 'readonly="readonly"'; ?>></td>
                </tr>
            </table>
            <input type="hidden" name="model_id" id="model_id" value="<?php echo $id ? esc_attr($id) : ''; ?>">
            <p class="submit"><input type="submit" name="mm_submit_model" class="button-primary" value="Save Model" id="save_model_button"></p>
        </form>
    </div>
    <script>
    function toggleCustomType() {
        var type = document.getElementById('type').value;
        var customType = document.getElementById('custom_type');
        customType.style.display = type === 'custom' ? 'inline-block' : 'none';
        toggleUserModelFields();
    }

    function toggleUserModelFields() {
        var type = document.getElementById('type').value;
        var isUserModel = type === 'user_container';
        document.getElementById('user_model_user_id_row').style.display = isUserModel ? '' : 'none';
        document.getElementById('user_model_class_name_row').style.display = isUserModel ? '' : 'none';
        document.getElementById('trigger_name_row').style.display = isUserModel ? 'none' : '';
        var modelId = document.getElementById('model_id').value;
        document.getElementById('save_model_button').disabled = isUserModel && !modelId;
        var userIdInput = document.getElementById('user_model_user_id');
        var classNameInput = document.getElementById('user_model_class_name');
        userIdInput.required = isUserModel;
        classNameInput.required = isUserModel;
    }
    toggleCustomType();
    </script>
    <?php
}
?>