<?php
/*
Plugin Name: LucyDream Image Webhook
Description: Spicy Image generation as part of the LucyDream plugin
Version: 1.0
Author: LucyDream
*/

// Define the trigger_loras array as a constant
define('TRIGGER_LORAS', [
    ['trigger' => 'nude', 'lora' => '<lora:nsfw_flux_lora_v1:0.5>'],
    ['trigger' => 'naked', 'lora' => '<lora:nsfw_flux_lora_v1:0.5>'],
    ['trigger' => 'no clothes', 'lora' => '<lora:nsfw_flux_lora_v1:0.5>'],
    ['trigger' => 'without clothes', 'lora' => '<lora:nsfw_flux_lora_v1:0.5>'],
    ['trigger' => 'pussy', 'lora' => '<lora:nsfw_flux_lora_v1:0.5>'],
    ['trigger' => 'topless', 'lora' => '<lora:flux_topless_v1:0.5>'],
    ['trigger' => 'vagina', 'lora' => '<lora:MysticXXX-v6:0.8>'],
    ['trigger' => 'vulva', 'lora' => '<lora:MysticXXX-v6:0.8>'],
]);

require_once WP_CONTENT_DIR . '/plugins/lucydream-credits/lucydream-credits.php';
require_once WP_CONTENT_DIR . '/plugins/aws-sdk/aws-autoloader.php'; 
require_once __DIR__ . '/lucydream-prompts.php';
require_once __DIR__ . '/lucydream-generate-form.php'; 
require_once __DIR__ . '/spicy-pending-tasks.php';
require_once __DIR__ . '/lucydream-api-settings.php';

use Aws\S3\S3Client;


function upload_to_r2($file_path, $bucket, $key) {
    $endpoint = "https://" . R2_ACCOUNT_ID . ".r2.cloudflarestorage.com";
    $public_endpoint = BUCKET_URL;
    $s3 = new S3Client([
        'region' => 'auto',
        'endpoint' => $endpoint,
        'credentials' => [
            'key' => R2_ACCESS_KEY_ID,
            'secret' => R2_SECRET_KEY
        ],
        'version' => 'latest'
    ]);
    try {
        $result = $s3->putObject([
            'Bucket' => $bucket,
            'Key' => $key,
            'Body' => fopen($file_path, 'r'),
            'ACL' => 'public-read'
        ]);
        $url = "$public_endpoint/$key";
        return $url;
    } catch (Exception $e) {
        return false;
    }
}

add_action('rest_api_init', function () {

    register_rest_route('lucydream/v1', '/generate', array(
        'methods' => 'POST',
        'callback' => 'handle_image_request',
        'permission_callback' => function($request) {
            $nonce = isset($_SERVER['HTTP_X_WP_NONCE']) ? $_SERVER['HTTP_X_WP_NONCE'] : '';
            $is_logged_in = is_user_logged_in();
            $user_id = get_current_user_id();
            $cookie = isset($_COOKIE['wordpress_logged_in_' . COOKIEHASH]) ? 'Present' : 'Absent';

            if (!$is_logged_in) {
                return new WP_Error('rest_forbidden', 'You must be logged in to generate images', array('status' => 401));
            }
            if (!wp_verify_nonce($nonce, 'wp_rest')) {
                return new WP_Error('rest_forbidden', 'Invalid or expired nonce', array('status' => 403));
            }
            return true;
        },
        'args' => array(
            'prompt'   => array('required' => true, 'type' => 'string'),
            'deviceId' => array('required' => true, 'type' => 'string'),
            'model'    => array('required' => true, 'type' => 'string'),
            'user_model' => array(
                'required' => false,
                'type' => 'string',
                'sanitize_callback' => 'sanitize_text_field'
            ),
            'api_mode' => array(
                'required' => false,
                'type' => 'string',
                'default' => 'spicy',
                'enum' => ['spicy'],
                'sanitize_callback' => 'sanitize_text_field'
            ),
            'keyword' => array(
                'required' => false,
                'type' => 'string',
                'sanitize_callback' => 'sanitize_text_field'
            )
        ),
    ));

    register_rest_route('lucydream/v1', '/all-images', array(
        'methods' => 'GET',
        'callback' => 'fetch_all_images',
        'permission_callback' => '__return_true',
        'args' => array(
            'model' => array(
                'required' => true,
                'type' => 'string',
                'default' => 'default',
            ),
            'user_id' => array(
                'required' => false,
                'type' => 'integer',
                'default' => 0,
            ),
        ),
    ));
    register_rest_route('lucydream/v1', '/image/(?P<random_key>[a-zA-Z0-9_-]+)', array(
        'methods' => 'GET',
        'callback' => 'serve_image',
        'permission_callback' => '__return_true',
    ));
});

function custom_log($message) {
    $log_file = WP_CONTENT_DIR . '/lucydream-image-debug.log';
    $log_entry = date('[Y-m-d H:i:s]') . ": $message\n";
    if (file_put_contents($log_file, $log_entry, FILE_APPEND | LOCK_EX) === false) {
        error_log("Failed to write to $log_file: $log_entry");
        error_log($log_entry); // Fallback to PHP error log
    }
}

function get_image_files($user_id = null, $tune_id = null) {
    $user_id = $user_id ?: get_current_user_id();
    $upload_dir = wp_upload_dir();
    $base_dir = $upload_dir['basedir'] . "/lucydream-images/$user_id/";
    $files = [];
    if ($tune_id) {
        $dir = "$base_dir$tune_id/";
        if (is_dir($dir)) {
            $files = glob($dir . '*.jpg');
        }
    } else {
        $dirs = glob("$base_dir*", GLOB_ONLYDIR);
        foreach ($dirs as $dir) {
            $files = array_merge($files, glob($dir . '*.jpg'));
        }
    }
    usort($files, function($a, $b) {
        return filemtime($b) - filemtime($a);
    });
    return $files;
}

function enforce_image_limit($max_images = 100, $user_id = null, $tune_id = null) {
    $user_id = $user_id ?: get_current_user_id();
    $files = get_image_files($user_id, $tune_id);
    if (count($files) > $max_images) {
        $files_to_delete = array_slice($files, $max_images);
        foreach ($files_to_delete as $file) {
            if (unlink($file)) {
            } else {
            }
        }
    }
}

function generate_thumbnail($source_path, $thumbnail_path, $width = 220, $height = 283) {
    $image = wp_get_image_editor($source_path);
    if (!is_wp_error($image)) {
        $image->resize($width, $height, true);
        $image->save($thumbnail_path);
        return true;
    }
    return false;
}


function cleanPrompt($fullPrompt, $tune_id = null, $api_mode = 'spicy') {
    global $wpdb;
    
    $models_table = $wpdb->prefix . 'model_manager_models';
    $user_models_table = $wpdb->prefix . 'model_manager_user_models';
    $cleaned = $fullPrompt;
    
$before = $cleaned;
$cleaned = preg_replace('/\bohwx\b\s*,?\s*/i', '', $cleaned);
$cleaned = preg_replace('/ohwx (woman|man)\s*,?\s*/i', '', $cleaned);

    $trigger_names = $wpdb->get_col("SELECT trigger_name FROM $models_table WHERE trigger_name IS NOT NULL AND trigger_name != ''");
    foreach ($trigger_names as $trigger_name) {
        $before = $cleaned;
        $cleaned = preg_replace('/' . preg_quote($trigger_name, '/') . '\s*,?\s*/i', '', $cleaned);
    }

    $class_names = $wpdb->get_col("SELECT class_name FROM $user_models_table WHERE class_name IS NOT NULL AND class_name != ''");
    foreach ($class_names as $class_name) {
        $before = $cleaned;
        $cleaned = preg_replace('/' . preg_quote($class_name, '/') . '\s*,?\s*/i', '', $cleaned);
    }

    if ($tune_id) {
        $lora_tag = "<lora:$tune_id:1>";
        $pattern = preg_replace('/:\d+(\.\d+)?/', ':[0-1](\.\d+)?', preg_quote($lora_tag, '/'));
        $before = $cleaned;
        $cleaned = preg_replace("/$pattern\s*,?\s*/i", '', $cleaned);
    }

    if ($api_mode === 'spicy') {
        $before = $cleaned;
        $cleaned = preg_replace('/<lora:[^>]+>\s*,?\s*/i', '', $cleaned);
    }
    
    $final_cleaned = trim($cleaned);
    return $final_cleaned;
}

function injectTriggerLoras($prompt, &$override_strength = null) {
    $triggers = TRIGGER_LORAS;
    $used_loras = [];
    $new_prompt_parts = [];
    $prompt_lower = strtolower($prompt);
    $words = preg_split('/(\s+|\b)/', $prompt, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);

    foreach ($words as $word) {
        $word_clean = strtolower(trim($word, ',.!?'));
        $trigger_lora = null;

        foreach ($triggers as $trigger) {
            $trigger_word = strtolower($trigger['trigger']);
            if (strpos($prompt_lower, $trigger_word) !== false && !in_array($trigger['lora'], $used_loras)) {
                if (strpos($trigger_word, $word_clean) !== false) {
                    $trigger_words = explode(' ', $trigger_word);
                    $current_pos = count($new_prompt_parts);
                    $is_last_word = true;
                    if (count($trigger_words) > 1) {
                        $is_last_word = ($word_clean === end($trigger_words));
                        for ($i = 0; $i < count($trigger_words) - 1; $i++) {
                            $prev_word_idx = $current_pos - (count($trigger_words) - 1 - $i) * 2;
                            if ($prev_word_idx < 0 || !isset($new_prompt_parts[$prev_word_idx]) || strtolower(trim($new_prompt_parts[$prev_word_idx], ',.!?')) !== $trigger_words[$i]) {
                                $is_last_word = false;
                                break;
                            }
                        }
                    }
                    if ($is_last_word) {
                        $trigger_lora = $trigger['lora'];
                        $used_loras[] = $trigger_lora;
                        $new_prompt_parts[] = $word;
                        $new_prompt_parts[] = $trigger_lora;
                        continue 2;
                    }
                }
            }
        }

        $new_prompt_parts[] = $word;
    }

    $new_prompt = implode('', $new_prompt_parts);
    return trim($new_prompt);
}

function handle_image_request($request) {
    $api_mode = sanitize_text_field($request['api_mode'] ?? 'spicy');
    set_time_limit(120);
    try {
        $start_time = microtime(true);
        $user_prompt = $request['prompt'];
        $device_id = sanitize_text_field($request['deviceId']);
        $model = sanitize_text_field($request['model']);
        $user_model_tune_id = sanitize_text_field($request['user_model'] ?? '');
        if (empty(trim($user_prompt))) {
            return new WP_REST_Response(array('error' => 'Please enter a prompt'), 400);
        }
        if (empty($device_id)) {
            return new WP_REST_Response(array('error' => 'Device identification required'), 400);
        }
        if (!in_array($model, ['default', 'my_models'])) {
            return new WP_REST_Response(['error' => 'Invalid model selected'], 400);
        }

        $user_id = get_current_user_id();

        $is_user_model = false;
        $tune_id = null;
        $gender = null;
        $model_lora_tag = '';
        $model_trigger_name = '';

        global $wpdb;
        $models_table = $wpdb->prefix . 'model_manager_models';

        if ($model === 'my_models' && $user_model_tune_id) {
            $user_models = function_exists('mm_get_user_models') ? mm_get_user_models($user_id) : [];
            foreach ($user_models as $um) {
    if ($um['tune_id'] === $user_model_tune_id) {
        $tune_id = $user_model_tune_id;
        $is_user_model = true;
        $gender = $um['class_name'];
        $model_lora_tag = "<lora:$tune_id:1>";
        $model_trigger_name = 'ohwx ' . $gender;
        $credit_cost = (float)$um['spicy_credit_cost'];
        break;
    }
}
            if (!$tune_id) {
                return new WP_REST_Response(['error' => 'Invalid user model selected'], 400);
            }
        } else {
            $model_field = is_numeric($model) ? 'tune_id' : 'type'; // Dynamically choose field: tune_id if numeric, else type
            $query = $wpdb->prepare("SELECT tune_id, trigger_name, spicy_credit_cost FROM $models_table WHERE $model_field = %s AND is_active = 1", $model);
            $model_data = $wpdb->get_row($query, ARRAY_A);

            if (!$model_data) {
                return new WP_REST_Response(['error' => 'Invalid model selected'], 400);
            }
            $tune_id = $model_data['tune_id'] ?? null;
$model_lora_tag = "<lora:$tune_id:1>";
$model_trigger_name = $model_data['trigger_name'] ?? '';
$credit_cost = (float)$model_data['spicy_credit_cost'];
if (!$tune_id) {
    return new WP_REST_Response(['error' => 'Model configuration incomplete'], 400);
}
        }

                
        $wpdb->query('START TRANSACTION');

        $balance = lucydream_calculate_balance($user_id);

        if ($balance < $credit_cost) {
            $wpdb->query('ROLLBACK');
            $user_id = get_current_user_id();
            return new WP_REST_Response(array(
                'error' => 'Insufficient credits. <a href="' . esc_url( site_url('/payments/') ) . '" class="buy-credits-link" target="_blank">Buy more credits</a>',
                'error_class' => 'insufficient-credits'
            ), 403);
        }

        $pending_request = new WP_REST_Request('POST', '');
        $pending_request->set_param('user_id', $user_id);
        $pending_request->set_param('credits', $credit_cost);
        $pending_request->set_param('reason', 'Image generation pending');
        $pending_response = lucydream_hold_credits($user_id, $credit_cost, 'Image generation pending');

        if (is_wp_error($pending_response) || !$pending_response['success']) {
            $wpdb->query('ROLLBACK');
            $error_msg = is_wp_error($pending_response) ? $pending_response->get_error_message() : $pending_response['message'];
            return new WP_REST_Response(array('error' => "Credit hold failed: $error_msg"), 500);
        }

        $pending_transaction_id = $pending_response['transaction_id'];
        $wpdb->query('COMMIT');
        $new_balance = lucydream_calculate_balance($user_id);

        $override_strength = null;
        $injected_prompt = $user_prompt;
        $injected_prompt = injectTriggerLoras($user_prompt, $override_strength);

        $full_prompt = "$model_lora_tag $model_trigger_name $injected_prompt";
$display_user_prompt = cleanPrompt($full_prompt, $tune_id, $api_mode);

    $pending_task_insert_id = null;
    $temp_task_id = null;
    $table_name = $wpdb->prefix . 'spicy_pending_tasks';
    $temp_task_id = 'pending_' . uniqid();
    $insert_result = $wpdb->insert($table_name, [
        'task_id' => $temp_task_id,
        'user_id' => $user_id,
        'tune_id' => $tune_id,
        'prompt' => $full_prompt,
        'user_prompt' => $display_user_prompt,
        'created_at' => current_time('mysql'),
        'updated_at' => current_time('mysql'),
        'status' => 'pending',
        'pending_transaction_id' => $pending_transaction_id,
    ]);
    if ($insert_result === false) {
        lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, 'Failed to log Spicy task');
        return new WP_REST_Response(['error' => 'Failed to log task. Please try again.'], 500);
    }
    $pending_task_insert_id = $wpdb->insert_id;

        if (!defined('PROXY_URL') || !defined('PROXY_SECRET_KEY') || empty(PROXY_URL) || empty(PROXY_SECRET_KEY)) {
            if ($pending_task_insert_id) {
                $wpdb->update($table_name, ['status' => 'failed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
            }
            $revert_response = lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, 'Proxy configuration error');
            if (is_wp_error($revert_response)) {
            } else {
            }
            return new WP_REST_Response(array('error' => 'Image generation failed due to server configuration issue'), 500);
        }

        $proxy_params = [
    'prompt' => $full_prompt,
    'deviceId' => $device_id,
    'model' => $model, 
    'tune_id' => $tune_id, 
    'user_model' => $user_model_tune_id, 
    'api_mode' => $api_mode,
    'keyword' => $request['keyword'] ?? '',
    'trigger_name' => $model_trigger_name, 
];
$proxy_endpoint = PROXY_URL . 'wp-json/whitelabel/v1/generate';
$response = wp_remote_post($proxy_endpoint, array(
            'headers' => array(
                'Content-Type' => 'application/json',
                'X-Proxy-Key' => PROXY_SECRET_KEY,
                'X-Request-Type'  => 'api',
            ),
            'body' => json_encode($proxy_params, JSON_UNESCAPED_SLASHES),
            'timeout' => 120,
            'redirection' => 5,
            'httpversion' => '1.1',
            'sslverify' => false, 
        ));

        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            if ($pending_task_insert_id) {
                $wpdb->update($table_name, ['status' => 'failed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
            }
            $revert_response = lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, "Proxy request failed: $error_message");
            if (is_wp_error($revert_response)) {
            } else {
            }
            return new WP_REST_Response(array('error' => 'Image generation failed due to network issue. Please try again.'), 500);
        }

        $status_code = wp_remote_retrieve_response_code($response);
        $raw_body = wp_remote_retrieve_body($response);
        $headers = wp_remote_retrieve_headers($response);
        $body = json_decode($raw_body, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            $json_error = json_last_error_msg();
            if ($pending_task_insert_id) {
                $wpdb->update($table_name, ['status' => 'failed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
            }
            $revert_response = lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, "Proxy response JSON decode error: $json_error");
            if (is_wp_error($revert_response)) {
            } else {
            }
            return new WP_REST_Response(array('error' => 'Image generation failed due to invalid server response'), 500);
        }

                if ($status_code === 202) {
            if ($pending_task_insert_id && isset($body['task_id'])) {
                $real_task_id = sanitize_text_field($body['task_id']);
                $wpdb->update($table_name, ['task_id' => $real_task_id], ['id' => $pending_task_insert_id]);
            }
            $new_balance = lucydream_calculate_balance($user_id);
            return new WP_REST_Response(array(
                'message' => $body['message'] ?? 'Image generation in progress. Please refresh in a few seconds.',
                'balance' => $new_balance,
                'task_id' => $body['task_id'] ?? null
            ), 202);
        }

                if ($status_code !== 200) {
            $error_msg = $body['error'] ?? 'Unknown proxy error';
            $detailed_error = $body['message'] ?? $raw_body ?: 'No additional error details provided';
            if ($pending_task_insert_id) {
                $wpdb->update($table_name, ['status' => 'failed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
            }
            $revert_response = lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, "Proxy error: $error_msg. Details: $detailed_error");
            if (is_wp_error($revert_response)) {
            } else {
            }
            return new WP_REST_Response(array(
                'error' => "Image generation failed: $error_msg",
                'details' => $detailed_error
            ), $status_code);
        }

        $image_url = $body['image_url'];
        $image_response = wp_remote_get($image_url, ['timeout' => 10]);
        if (is_wp_error($image_response)) {
            $error_message = $image_response->get_error_message();
            if ($pending_task_insert_id) {
                $wpdb->update($table_name, ['status' => 'failed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
            }
            $revert_response = lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, 'Image fetch failed');
            if (is_wp_error($revert_response)) {
            } else {
            }
            return new WP_REST_Response(array('error' => 'Failed to retrieve generated image. Please try again.'), 500);
        }
        $image_data = wp_remote_retrieve_body($image_response);

        $random_key_base = bin2hex(random_bytes(16));
        $random_key = $random_key_base;
        $upload_dir = wp_upload_dir();
        $user_dir = "/lucydream-images/$user_id/$tune_id/";
        $file_path = $upload_dir['basedir'] . $user_dir . $random_key . '_' . $tune_id . '.jpg';
        $thumbnail_path = $upload_dir['basedir'] . $user_dir . $random_key . '_' . $tune_id . '_thumb.jpg';
        $file_url = $upload_dir['baseurl'] . $user_dir . $random_key . '_' . $tune_id . '.jpg';
        $thumbnail_url = $upload_dir['baseurl'] . $user_dir . $random_key . '_' . $tune_id . '_thumb.jpg';

        if (!file_exists(dirname($file_path))) {
            mkdir(dirname($file_path), 0755, true);
        }
        if (file_put_contents($file_path, $image_data) === false) {
            if ($pending_task_insert_id) {
                $wpdb->update($table_name, ['status' => 'failed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
            }
            $revert_response = lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, 'Failed to store image');
            if (is_wp_error($revert_response)) {
            } else {
            }
            return new WP_REST_Response(array('error' => 'Failed to store image'), 500);
        }
        chmod($file_path, 0644);

        $thumbnail_generated = generate_thumbnail($file_path, $thumbnail_path);
        if (!$thumbnail_generated) {
            $thumbnail_url = $file_url;
        }
        update_option("lucydream_image_thumbnail_{$random_key}", $thumbnail_generated ? $thumbnail_url : $file_url);

        $full_prompt = $body['prompt'] ?? $full_prompt;
        $display_user_prompt = $body['user_prompt'] ?? $display_user_prompt;

        update_option("lucydream_image_user_{$random_key}", $user_id);
        update_option("lucydream_image_prompt_{$random_key}", $full_prompt);
        update_option("lucydream_image_user_prompt_{$random_key}", $display_user_prompt);
        enforce_image_limit(100, $user_id, $tune_id);

        $commit_response = lucydream_commit_pending_credits($user_id, $credit_cost, $pending_transaction_id, 'Image generation');
        if (is_wp_error($commit_response) || !$commit_response['success']) {
            $error_msg = is_wp_error($commit_response) ? $commit_response->get_error_message() : $commit_response['message'];
            if ($pending_task_insert_id) {
                $wpdb->update($table_name, ['status' => 'failed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
            }
            lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, 'Failed to commit credits');
            return new WP_REST_Response(array('error' => "Credit commit failed: $error_msg"), 500);
        }
        $new_balance = lucydream_calculate_balance($user_id);

                if ($pending_task_insert_id) {
            $wpdb->update($table_name, ['status' => 'completed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
        }

        return new WP_REST_Response(array(
            'image_url' => $file_url,
            'thumbnail_url' => get_option("lucydream_image_thumbnail_{$random_key}", $thumbnail_url),
            'prompt' => $full_prompt,
            'user_prompt' => $display_user_prompt,
            'w' => 896,
            'h' => 1152,
            'balance' => $new_balance
        ), 200);

        } catch (Exception $e) {
        if (isset($pending_transaction_id)) {
            $revert_response = lucydream_revert_pending_credits($user_id, $credit_cost, $pending_transaction_id, 'Exception: ' . $e->getMessage());
            if (is_wp_error($revert_response)) {
            } else {
            }
        }
        if ($pending_task_insert_id) {
            $wpdb->update($table_name, ['status' => 'failed', 'updated_at' => current_time('mysql')], ['id' => $pending_task_insert_id]);
        }
        return new WP_REST_Response(array('error' => 'Internal server error: ' . $e->getMessage()), 500);
    }
}

function fetch_all_images($request) {
    try {
        $user_id = (int) $request->get_param('user_id') ?: get_current_user_id();
        $model = sanitize_text_field($request['model'] ?? 'default');
        $tune_ids = sanitize_text_field($request->get_param('tune_ids') ?? '');
        $multi_tune_only = (bool) $request->get_param('multi_tune_only') ?? false;

        global $wpdb;
$models_table = $wpdb->prefix . 'model_manager_models';

if ($model === 'default') {
    $tune_id = $wpdb->get_var($wpdb->prepare("SELECT tune_id FROM $models_table WHERE type = %s AND is_active = 1 LIMIT 1", 'default'));
    if (!$tune_id) {
        return new WP_REST_Response(['error' => 'No default model available'], 404);
    }
} else {
    $tune_id = ($model === 'my_models' ? null : $model);
}
        $is_user_model = !isset($model_tune_ids[$model]);

        $upload_dir = wp_upload_dir();
        $base_dir = $upload_dir['basedir'] . "/lucydream-images/$user_id/";
        $images = [];

        if ($tune_ids) {
            $tune_id_array = array_filter(array_map('trim', explode(',', $tune_ids)));
            if (empty($tune_id_array)) {
                return new WP_REST_Response($images, 200);
            }

            $dirs = glob("$base_dir*", GLOB_ONLYDIR);
            foreach ($dirs as $dir) {
                $dir_name = basename($dir);
                $is_multi_tune = strpos($dir_name, '-') !== false;
                if ($multi_tune_only && !$is_multi_tune) {
                    continue;
                }

                $dir_tune_ids = explode('-', $dir_name);
                $matches_tune_id = false;
                foreach ($tune_id_array as $requested_tune_id) {
                    if (in_array($requested_tune_id, $dir_tune_ids)) {
                        $matches_tune_id = true;
                        break;
                    }
                }

                if ($matches_tune_id) {
                    $files = glob("$dir/*.jpg");
                    usort($files, function($a, $b) {
                        return filemtime($b) - filemtime($a);
                    });

                    foreach ($files as $file) {
                        $basename = basename($file);
                        $parts = explode('_', str_replace('.jpg', '', $basename));
                        $file_tune_id = array_pop($parts);
                        $is_thumbnail = $file_tune_id === 'thumb';
                        if ($is_thumbnail) {
                            $file_tune_id = array_pop($parts);
                        }
                        $random_key = implode('_', $parts);

                        if (!$is_thumbnail) {
                            $file_url = $upload_dir['baseurl'] . "/lucydream-images/$user_id/$dir_name/" . $random_key . '_' . $dir_name . '.jpg';
                            $thumbnail_path = $upload_dir['basedir'] . "/lucydream-images/$user_id/$dir_name/" . $random_key . '_' . $dir_name . '_thumb.jpg';
                            $thumbnail_url = file_exists($thumbnail_path) 
                                ? $upload_dir['baseurl'] . "/lucydream-images/$user_id/$dir_name/" . $random_key . '_' . $dir_name . '_thumb.jpg' 
                                : $file_url;
                            $stored_prompt = get_option("lucydream_image_prompt_{$random_key}", 'Generated image');
                            $stored_user_prompt = get_option("lucydream_image_user_prompt_{$random_key}", $stored_prompt);
                            $images[] = [
                                'image_url' => $file_url,
                                'thumbnail_url' => $thumbnail_url,
                                'prompt' => $stored_prompt,
                                'user_prompt' => $stored_user_prompt,
                                'w' => 896,
                                'h' => 1152,
                                'timestamp' => filemtime($file)
                            ];
                        }
                    }
                    enforce_image_limit(100, $user_id, $dir_name);
                }
            }
        } else {
            $base_dir = $upload_dir['basedir'] . "/lucydream-images/$user_id/" . ($tune_id ? "$tune_id/" : '');
            $files = get_image_files($user_id, $tune_id);
            enforce_image_limit(100, $user_id, $tune_id);

            foreach ($files as $file) {
                $basename = basename($file);
                $parts = explode('_', str_replace('.jpg', '', $basename));
                $file_tune_id = array_pop($parts);
                $is_thumbnail = $file_tune_id === 'thumb';
                if ($is_thumbnail) {
                    $file_tune_id = array_pop($parts);
                }
                $random_key = implode('_', $parts);
                if ($file_tune_id === $tune_id && !$is_thumbnail) {
                    $file_url = $upload_dir['baseurl'] . "/lucydream-images/$user_id/$tune_id/" . $random_key . '_' . $tune_id . '.jpg';
                    $thumbnail_path = $upload_dir['basedir'] . "/lucydream-images/$user_id/$tune_id/" . $random_key . '_' . $tune_id . '_thumb.jpg';
                    $thumbnail_url = file_exists($thumbnail_path) 
                        ? $upload_dir['baseurl'] . "/lucydream-images/$user_id/$tune_id/" . $random_key . '_' . $tune_id . '_thumb.jpg' 
                        : $file_url;
                    $stored_prompt = get_option("lucydream_image_prompt_{$random_key}", 'Generated image');
                    $stored_user_prompt = get_option("lucydream_image_user_prompt_{$random_key}", $stored_prompt);
                    $images[] = [
                        'image_url' => $file_url,
                        'thumbnail_url' => $thumbnail_url,
                        'prompt' => $stored_prompt,
                        'user_prompt' => $stored_user_prompt,
                        'w' => 896,
                        'h' => 1152
                    ];
                }
            }
        }

        $response = new WP_REST_Response($images, 200);
        $response->header('Cache-Control', 'no-store');
        return $response;
    } catch (Exception $e) {
        $error_response = new WP_REST_Response(array('error' => 'Internal server error: ' . $e->getMessage()), 500);
        $error_response->header('Cache-Control', 'no-cache');
        return $error_response;
    }
}

function serve_image($request) {
    try {
        $provided = $request['random_key'];
        $last_underscore = strrpos($provided, '_');
        if ($last_underscore === false) {
            return new WP_REST_Response(array('error' => 'Invalid image reference'), 400);
        }
        $tune_id = substr($provided, $last_underscore + 1);
        $random_key = substr($provided, 0, $last_underscore);

        $user_id = get_option("lucydream_image_user_{$random_key}", false);
        if (!$user_id) {
            $user_id = get_current_user_id();
        }

        $upload_dir = wp_upload_dir();
        $file_path = $upload_dir['basedir'] . "/lucydream-images/$user_id/$tune_id/" . $random_key . '_' . $tune_id . '.jpg';

        if (file_exists($file_path)) {
            header("Content-Type: image/jpeg");
            header("Access-Control-Allow-Origin: *");
            header("Cache-Control: no-cache, must-revalidate");
            readfile($file_path);
            exit;
        } else {
            return new WP_REST_Response(array('error' => 'Image not found in storage'), 404);
        }
    } catch (Exception $e) {
        return new WP_REST_Response(array('error' => 'Internal server error: ' . $e->getMessage()), 500);
    }
}

function get_fresh_nonce_callback() {
    if (!is_user_logged_in()) {
        wp_send_json_error(['message' => 'User not logged in'], 401);
    }
    $nonce = wp_create_nonce('wp_rest');
    wp_send_json_success(['nonce' => $nonce]);
}
add_action('wp_ajax_get_fresh_nonce', 'get_fresh_nonce_callback');

function create_image_generator_page() {
    $page = get_page_by_path('image-generator');
    if (!$page) {
        $page_args = array(
            'post_title'    => 'Image Generator',
            'post_content'  => '[user_info][dynamic_generate_form]',
            'post_status'   => 'publish',
            'post_type'     => 'page',
        );
        wp_insert_post($page_args);
    }
}

register_activation_hook(__FILE__, 'create_image_generator_page');

// Activation hook to create the spicy_pending_tasks table
register_activation_hook(__FILE__, 'ld_create_spicy_pending_tasks_table');

function ld_create_spicy_pending_tasks_table() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();

    $table_name = $wpdb->prefix . 'spicy_pending_tasks';
    $sql = "CREATE TABLE $table_name (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        task_id VARCHAR(50) NOT NULL,
        user_id BIGINT(20) UNSIGNED NOT NULL,
        tune_id VARCHAR(20) NOT NULL,
        prompt TEXT NOT NULL,
        user_prompt TEXT NOT NULL,
        created_at DATETIME DEFAULT NULL,
        updated_at DATETIME DEFAULT NULL,
        status VARCHAR(20) DEFAULT 'pending',
        pending_transaction_id VARCHAR(50) DEFAULT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);
}

// Plugin Activation: Create SQL tables for spicy prompts
register_activation_hook(__FILE__, 'lucydream_prompts_activate');
function lucydream_prompts_activate() {
    global $wpdb;
    $spicy_table = $wpdb->prefix . 'spicy_prompts';
    $charset_collate = $wpdb->get_charset_collate();

    $spicy_sql = "CREATE TABLE IF NOT EXISTS $spicy_table (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        prompt text NOT NULL,
        created_at datetime DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($spicy_sql);
} 

?>