<?php
/**
 * LucyDream Generate Form Shortcode
 * Contains the dynamic_generate_form_shortcode and related AJAX handler
 */

function dynamic_generate_form_shortcode() {
    if (!is_user_logged_in()) {
        return '<p>Please log in to generate images.</p>';
    }
    
    global $wpdb;
    $models_table = $wpdb->prefix . 'model_manager_models';
    $user_models_table = $wpdb->prefix . 'model_manager_user_models';
    $trigger_names = $wpdb->get_col("SELECT trigger_name FROM $models_table WHERE trigger_name IS NOT NULL AND trigger_name != ''");
    $class_names = $wpdb->get_col("SELECT class_name FROM $user_models_table WHERE class_name IS NOT NULL AND class_name != ''");

    wp_enqueue_script('lucydream-generate', plugins_url('lucydream-generate.js', __DIR__ . '/lucydream-image-webhook.php'), ['jquery'], '1.0', true);
    wp_localize_script('lucydream-generate', 'lucydream_data', [
        'api_url' => rest_url('lucydream/v1/'),
        'nonce' => wp_create_nonce('wp_rest'),
        'user_id' => get_current_user_id(),
        'trigger_names' => $trigger_names, 
        'class_names' => $class_names,
    ]);
    
    wp_enqueue_style('lucydream-slider-lightbox', plugins_url('lucydream-slider-lightbox.css', __FILE__), array(), '1.0', 'all');

    $user_id = get_current_user_id();
    $user_models = function_exists('mm_get_user_models') ? mm_get_user_models($user_id) : [];
    $has_user_models = !empty($user_models);

    ob_start();
    ?>
    <?php
    $generate_settings = [
        'generate_heading_text' => 'Generate Image',
        'prompt_placeholder_text' => 'Enter your prompt here...',
        'generated_images_heading_text' => 'Generated Images',
    ];
    ?>
    <div id="custom-container">
      <h2 style="margin-top: 50px;"><?php echo esc_html($generate_settings['generate_heading_text']); ?></h2>
      <form class="custom-form" id="custom-form" method="post" style="position: relative;">
            <div class="dropdown-container" style="display: flex; gap: 15px; align-items: center;">
  <span id="mode-info">Mode: 
    <select id="api_mode" name="api_mode" required>
        <option value="" selected disabled>---</option>
        <option value="spicy">Spicy🌶️</option>
    </select>
  </span>
  <span id="model-info">Model:  
    <select id="model" name="model" required>
        <option value="" selected disabled>---</option>
        <option value="default">Lucy Dream</option>
        <option value="my_models">My Models</option>
    </select>
  </span>
  <span id="user-model-choice" class="hidden" style="display: none; align-items: center; gap: 5px;">
      <?php if ($has_user_models): ?>
          Name: 
          <select id="user-model" name="user_model">
              <option value="" selected disabled>---</option>
              <?php foreach ($user_models as $model): ?>
                  <option value="<?php echo esc_attr($model['tune_id']); ?>" data-class="<?php echo esc_attr($model['class_name']); ?>" data-status="<?php echo esc_attr($model['training_status']); ?>" data-created="<?php echo esc_attr(strtotime($model['created_at'])); ?>">
                      <?php echo esc_html($model['name']); ?>
                  </option>
              <?php endforeach; ?>
          </select>
      <?php else: ?>
          <a href="<?php echo esc_url(home_url('/create-model/')); ?>" class="create-model-link">Create Your Model</a>
      <?php endif; ?>
  </span>
</div>
            <textarea id="prompt-input" name="prompt" placeholder="<?php echo esc_attr($generate_settings['prompt_placeholder_text']); ?>" rows="4" cols="50" required style="margin-top: 10px;"></textarea><br>
            <input type="hidden" id="deviceId" name="deviceId">
            <div style="display: flex; justify-content: space-between; align-items: center;">
              <button type="submit" id="generate-button" disabled>Generate Image</button>
              <button type="button" id="random-prompt-button">🌶️</button>
            </div>
            <style>
  #random-prompt-button {
    font-size: 0.9em; /* 50% of parent's font-size (relative to generate-button if same parent) */
    padding: 5px 10px; /* Half the padding for proportional sizing */
    transform: scale(0.9); /* Visual scale-down; use this if you want exact 50% shrinkage */
    transform-origin: center; /* Keeps it centered during scaling */
  }
</style>
            <p id="prompt-limit-message"></p>
        </form>
          <div id="custom-images" style="margin-top: 100px;">
            <h3><?php echo esc_html($generate_settings['generated_images_heading_text']); ?></h3>
            <div class="slider-container">
              <div class="slider-wrapper" id="slider-wrapper">
                <p>Please select a model from the "Model:" dropdown</p>
              </div>
              <button class="slider-nav prev" id="prev-slide" disabled>❮</button>
              <button class="slider-nav next" id="next-slide" disabled>❯</button>
            </div>
            <div id="lightbox" class="lightbox" style="display: none;">
              <div class="lightbox-content">
                <button class="lightbox-nav prev" id="lightbox-prev" disabled>❮</button>
                <button class="lightbox-nav next" id="lightbox-next" disabled>❯</button>
                <div class="lightbox-image"></div>
                <div class="lightbox-prompt"></div>
              </div>
            </div>
          </div>
        </div>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('custom-form');
        const modelSelect = document.getElementById('model');
        const userModelChoice = document.getElementById('user-model-choice');
        const userModelSelect = document.getElementById('user-model');
        const generateButton = document.getElementById('generate-button');
        const wrapper = document.getElementById('slider-wrapper');
        const message = document.getElementById('prompt-limit-message');
        const randomPromptButton = document.getElementById('random-prompt-button');
        const promptInput = document.getElementById('prompt-input');
        const apiModeSelect = document.getElementById('api_mode');
        let isInitialLoad = true;
        const bannedWords = ['child', 'girl', 'boy', 'baby', 'toddler', 'teenage', 'teen', 'teenager'];
        const ageRange = Array.from({length: 18}, (_, i) => i);

        function generateDeviceId() {
            return btoa([navigator.userAgent.replace(/\s/g, ''), `${screen.width}x${screen.height}x${screen.colorDepth}`, navigator.platform || 'unknown', Date.now()].join('|')).substring(0, 64);
        }
        document.getElementById('deviceId').value = generateDeviceId();

        function toggleDropdownsAndButton() {
            let validSelection = false;
            randomPromptButton.textContent = '🌶️';

            if (modelSelect.value === 'my_models') {
                userModelChoice.classList.remove('hidden');
                userModelChoice.style.display = 'flex';
                if (userModelSelect && userModelSelect.value) {
                    const status = userModelSelect.options[userModelSelect.selectedIndex].getAttribute('data-status');
                    const createdTime = parseInt(userModelSelect.options[userModelSelect.selectedIndex].getAttribute('data-created')) * 1000;
                    const now = Date.now();
                    const thirtyMinutes = 30 * 60 * 1000;
                    if (status === 'pending' && (now - createdTime) < thirtyMinutes) {
                        const remainingMins = Math.ceil((thirtyMinutes - (now - createdTime)) / 60000);
                        message.textContent = `Model is training, available in ${remainingMins} minute${remainingMins > 1 ? 's' : ''}.`;
                        message.className = 'limit-exceeded';
                    } else {
                        validSelection = true;
                        if (status === 'pending') {
                            fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                                body: `action=update_model_status&tune_id=${encodeURIComponent(userModelSelect.value)}&_wpnonce=<?php echo wp_create_nonce('wp_rest'); ?>`
                            });
                        }
                    }
                }
            } else if (modelSelect.value) {
                userModelChoice.classList.add('hidden');
                userModelChoice.style.display = 'none';
                validSelection = true;
            }
            generateButton.disabled = !validSelection;
            if (validSelection && !isInitialLoad && typeof loadAllImages === 'function') loadAllImages();
        }

        async function fetchPrompt() {
        message.textContent = 'Generating prompt...';
        message.className = 'generating';
        randomPromptButton.disabled = true;
        try {
            let freshNonce = lucydream_data.nonce;
            try {
                const nonceResponse = await fetch('/wp-admin/admin-ajax.php?action=get_fresh_nonce', {
                    method: 'POST',
                    credentials: 'include',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'X-WP-Nonce': lucydream_data.nonce
                    },
                });
                const nonceText = await nonceResponse.text();
                let nonceData;
                try {
                    nonceData = JSON.parse(nonceText);
                } catch (jsonError) {
                    throw new Error('Invalid nonce response format');
                }
                if (nonceResponse.ok && nonceData.success && nonceData.data.nonce) {
                    freshNonce = nonceData.data.nonce;
                } else {
                    throw new Error('Failed to fetch fresh nonce');
                }
            } catch (nonceError) {
                message.textContent = 'Error: Unable to verify request. Please refresh the page.';
                message.className = 'error';
                generateButton.disabled = false;
                clearPersistentRequest();
                return;
            }

            const endpoint = 'generate-prompt';
            const response = await fetch(lucydream_data.api_url + endpoint, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-WP-Nonce': freshNonce
                },
                body: JSON.stringify({})
            });
            const data = await response.json();
            if (response.ok) {
                promptInput.value = data.prompt;
                message.textContent = '';
            } else {
                message.textContent = data.message || 'Error generating prompt.';
                if (response.status === 429) {
                    message.textContent = 'Rate limit reached. Please try again later.';
                } else if (response.status === 500) {
                    message.textContent = 'Server issue. Please try again.';
                }
            }
        } catch (error) {
            console.error('Error fetching prompt:', error);
            message.textContent = 'Error generating prompt. Please try again.';
        } finally {
            randomPromptButton.disabled = false;
        }
    }

        function validatePrompt(prompt) {
            const lowerPrompt = prompt.toLowerCase();
            for (const word of bannedWords) {
                if (lowerPrompt.includes(word)) return false;
            }
            const agePattern = new RegExp(`\\b(${ageRange.join('|')})\\s*(year|years|yr|yo|yrs|old|-year|-years)\\b`, 'i');
            return !agePattern.test(lowerPrompt);
        }

        toggleDropdownsAndButton();
        modelSelect.addEventListener('change', () => { isInitialLoad = false; toggleDropdownsAndButton(); });
        if (userModelSelect) userModelSelect.addEventListener('change', () => { isInitialLoad = false; toggleDropdownsAndButton(); });
        apiModeSelect.addEventListener('change', toggleDropdownsAndButton);
        randomPromptButton.addEventListener('click', fetchPrompt);
    });
    </script>
        <?php
        return ob_get_clean();
    }
    add_shortcode('dynamic_generate_form', 'dynamic_generate_form_shortcode');

    ?>