<?php
/*
 * lucydream-api-settings.php
 * Handles admin settings for LucyDream API constants.
 */

// Define constants using saved options
if (!defined('PROXY_URL')) {
    define('PROXY_URL', get_option('lucydream_proxy_url', 'https://my.lucydream.ai/'));
}
if (!defined('PROXY_SECRET_KEY')) {
    define('PROXY_SECRET_KEY', get_option('lucydream_proxy_secret_key', ''));
}
if (!defined('R2_ACCOUNT_ID')) {
    define('R2_ACCOUNT_ID', get_option('lucydream_r2_account_id', ''));
}
if (!defined('R2_ACCESS_KEY_ID')) {
    define('R2_ACCESS_KEY_ID', get_option('lucydream_r2_access_key_id', ''));
}
if (!defined('R2_SECRET_KEY')) {
    define('R2_SECRET_KEY', get_option('lucydream_r2_secret_key', ''));
}
if (!defined('BUCKET_URL')) {
    define('BUCKET_URL', get_option('lucydream_bucket_url', ''));
}
if (!defined('BUCKET_NAME')) {
    define('BUCKET_NAME', get_option('lucydream_bucket_name', ''));
}

// Only load admin settings code in the admin area
if (is_admin()) {
    add_action('admin_menu', 'lucydream_add_api_menu');
    add_action('admin_init', 'lucydream_register_api_settings');

    function lucydream_add_api_menu() {
        add_options_page(
            'LucyDream API Settings',    // Page title
            'LucyDream API',             // Menu title
            'manage_options',            // Capability
            'lucydream-api',             // Menu slug
            'lucydream_api_settings_page' // Callback function
        );
    }

    function lucydream_register_api_settings() {
        register_setting('lucydream_api_options', 'lucydream_proxy_url', 'sanitize_text_field');
        register_setting('lucydream_api_options', 'lucydream_proxy_secret_key', 'sanitize_text_field');
        register_setting('lucydream_api_options', 'lucydream_r2_account_id', 'sanitize_text_field');
        register_setting('lucydream_api_options', 'lucydream_r2_access_key_id', 'sanitize_text_field');
        register_setting('lucydream_api_options', 'lucydream_r2_secret_key', 'sanitize_text_field');
        register_setting('lucydream_api_options', 'lucydream_bucket_url', 'sanitize_text_field');
        register_setting('lucydream_api_options', 'lucydream_bucket_name', 'sanitize_text_field');
        register_setting('lucydream_api_options', 'lucydream_cron_secret_key', 'sanitize_text_field');

        add_settings_section(
            'lucydream_api_section',     // Section ID
            'API Settings',              // Section title
            null,                        // Callback (optional)
            'lucydream-api'              // Page slug
        );

        add_settings_field(
            'lucydream_proxy_url',       // Field ID
            'API URL',                 // Field title
            'lucydream_proxy_url_callback', // Callback
            'lucydream-api',             // Page slug
            'lucydream_api_section'      // Section ID
        );

        add_settings_field(
            'lucydream_proxy_secret_key', // Field ID
            'API Secret Key',          // Field title
            'lucydream_proxy_secret_key_callback', // Callback
            'lucydream-api',             // Page slug
            'lucydream_api_section'      // Section ID
        );

        add_settings_field(
            'lucydream_r2_account_id',   // Field ID
            'R2 Account ID',           // Field title
            'lucydream_r2_account_id_callback', // Callback
            'lucydream-api',             // Page slug
            'lucydream_api_section'      // Section ID
        );

        add_settings_field(
            'lucydream_r2_access_key_id', // Field ID
            'R2 Access Key ID',        // Field title
            'lucydream_r2_access_key_id_callback', // Callback
            'lucydream-api',             // Page slug
            'lucydream_api_section'      // Section ID
        );

        add_settings_field(
            'lucydream_r2_secret_key',   // Field ID
            'R2 Secret Key',           // Field title
            'lucydream_r2_secret_key_callback', // Callback
            'lucydream-api',             // Page slug
            'lucydream_api_section'      // Section ID
        );

        add_settings_field(
            'lucydream_bucket_url',      // Field ID
            'Bucket URL',              // Field title
            'lucydream_bucket_url_callback', // Callback
            'lucydream-api',             // Page slug
            'lucydream_api_section'      // Section ID
        );

        add_settings_field(
            'lucydream_bucket_name',     // Field ID
            'Bucket Name',             // Field title
            'lucydream_bucket_name_callback', // Callback
            'lucydream-api',             // Page slug
            'lucydream_api_section'      // Section ID
        );

        add_settings_field(
            'lucydream_cron_secret_key', // Field ID
            'External Cron Secret Key',  // Field title
            'lucydream_cron_secret_key_callback', // Callback
            'lucydream-api',             // Page slug
            'lucydream_api_section'      // Section ID
        );
    }

    function lucydream_api_settings_page() {
        ?>
        <div class="wrap">
            <h1>LucyDream API Settings</h1>
            <form method="post" action="options.php">
                <?php
                settings_fields('lucydream_api_options');
                do_settings_sections('lucydream-api');
                submit_button();
                ?>
            </form>
        </div>
        <?php
    }

    function lucydream_proxy_url_callback() {
        $value = esc_attr(get_option('lucydream_proxy_url', 'https://my.lucydream.ai/'));
        echo '<input type="url" name="lucydream_proxy_url" value="' . $value . '" class="regular-text" readonly />';
        echo '<p class="description">The base API URL.</p>';
    }

    function lucydream_proxy_secret_key_callback() {
        $value = esc_attr(get_option('lucydream_proxy_secret_key', ''));
        echo '<input type="text" name="lucydream_proxy_secret_key" value="' . $value . '" class="regular-text" />';
        echo '<p class="description">Enter the API secret key.</p>';
    }

    function lucydream_r2_account_id_callback() {
        $value = esc_attr(get_option('lucydream_r2_account_id', ''));
        echo '<input type="text" name="lucydream_r2_account_id" value="' . $value . '" class="regular-text" />';
        echo '<p class="description">Enter the R2 Account ID.</p>';
    }

    function lucydream_r2_access_key_id_callback() {
        $value = esc_attr(get_option('lucydream_r2_access_key_id', ''));
        echo '<input type="text" name="lucydream_r2_access_key_id" value="' . $value . '" class="regular-text" />';
        echo '<p class="description">Enter the R2 Access Key ID.</p>';
    }

    function lucydream_r2_secret_key_callback() {
        $value = esc_attr(get_option('lucydream_r2_secret_key', ''));
        echo '<input type="text" name="lucydream_r2_secret_key" value="' . $value . '" class="regular-text" />';
        echo '<p class="description">Enter the R2 Secret Key.</p>';
    }

    function lucydream_bucket_url_callback() {
        $value = esc_attr(get_option('lucydream_bucket_url', ''));
        echo '<input type="url" name="lucydream_bucket_url" value="' . $value . '" class="regular-text" />';
        echo '<p class="description">Enter the Bucket URL.</p>';
    }

    function lucydream_bucket_name_callback() {
        $value = esc_attr(get_option('lucydream_bucket_name', ''));
        echo '<input type="text" name="lucydream_bucket_name" value="' . $value . '" class="regular-text" />';
        echo '<p class="description">Enter the Bucket Name.</p>';
    }

    function lucydream_cron_secret_key_callback() {
        $value = esc_attr(get_option('lucydream_cron_secret_key'));
        echo '<input type="text" name="lucydream_cron_secret_key" value="' . $value . '" class="regular-text" />';
        echo '<p class="description">Enter the external cron secret key.</p>';
    }
}