jQuery(document).ready(function($) {
    // Existing balance editing functionality
    $('.lucydream-editable-balance').on('click', function() {
        var $this = $(this);
        var userId = $this.data('user-id');
        var nonce = $this.data('nonce');
        var currentBalance = $this.data('balance');
        var newBalance = prompt('Enter new balance for User ID ' + userId + ':', currentBalance);

        if (newBalance !== null && !isNaN(newBalance) && newBalance !== '') {
            $.ajax({
                url: lucydream_ajax.ajax_url,
                method: 'POST',
                data: {
                    action: 'lucydream_update_balance',
                    user_id: userId,
                    new_balance: newBalance,
                    nonce: nonce
                },
                success: function(response) {
                    if (response.success) {
                        $this.text(response.data.new_balance);
                        $this.data('balance', response.data.new_balance);
                        alert(response.data.message);
                    } else {
                        alert('Error: ' + response.data.message);
                    }
                },
                error: function() {
                    alert('An error occurred while updating the balance.');
                }
            });
        }
    });
});