document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('create-model-form');
    const button = document.getElementById('create-model-button');
    const message = document.getElementById('model-status-message');
    const deviceIdInput = document.getElementById('deviceId');

    function generateDeviceId() {
        const deviceId = [navigator.userAgent.replace(/\s/g, ''), `${screen.width}x${screen.height}x${screen.colorDepth}`, navigator.platform || 'unknown', Date.now().toString()].join('|');
        return btoa(deviceId).substring(0, 64);
    }
    deviceIdInput.value = generateDeviceId();

    form.addEventListener('submit', async function(e) {
        e.preventDefault();
        button.disabled = true;
        message.textContent = 'Processing...';
        message.className = '';

        const formData = new FormData(form);
        formData.append('_wpnonce', lucydream_ajax.nonce);

        try {
            const response = await fetch(lucydream_ajax.ajax_url, { 
                method: 'POST', 
                body: formData
            });
            const data = await response.json();

            if (data.success) {
                message.innerHTML = 'Model creation initiated. Training may take up to 30 minutes.<br>' +
                    'You can <a href="/image-generator/">generate AI images</a> once your model is ready';
                message.className = 'success';
            } else {
                const errorMessage = data.data?.message || 'Error creating model.';
                const errorClass = data.data?.message_class || 'error';
                message.innerHTML = errorMessage;
                message.className = errorClass;
                if (response.status === 429) {
                    message.innerHTML = 'Another model creation is in progress. Please try again later.';
                    message.className = 'error';
                }
            }
        } catch (error) {
            message.textContent = 'Error: Unable to process request. Please try again.';
            message.className = 'error';
        } finally {
            button.disabled = false;
        }
    });
});